<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\PagespeedInsights;

class RendererFormattedStrings extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * @var string
     */
    public $auditGroupExpandTooltip;
    /**
     * @var string
     */
    public $calculatorLink;
    /**
     * @var string
     */
    public $crcInitialNavigation;
    /**
     * @var string
     */
    public $crcLongestDurationLabel;
    /**
     * @var string
     */
    public $dropdownCopyJSON;
    /**
     * @var string
     */
    public $dropdownDarkTheme;
    /**
     * @var string
     */
    public $dropdownPrintExpanded;
    /**
     * @var string
     */
    public $dropdownPrintSummary;
    /**
     * @var string
     */
    public $dropdownSaveGist;
    /**
     * @var string
     */
    public $dropdownSaveHTML;
    /**
     * @var string
     */
    public $dropdownSaveJSON;
    /**
     * @var string
     */
    public $dropdownViewer;
    /**
     * @var string
     */
    public $errorLabel;
    /**
     * @var string
     */
    public $errorMissingAuditInfo;
    /**
     * @var string
     */
    public $footerIssue;
    /**
     * @var string
     */
    public $labDataTitle;
    /**
     * @var string
     */
    public $lsPerformanceCategoryDescription;
    /**
     * @var string
     */
    public $manualAuditsGroupTitle;
    /**
     * @var string
     */
    public $notApplicableAuditsGroupTitle;
    /**
     * @var string
     */
    public $opportunityResourceColumnLabel;
    /**
     * @var string
     */
    public $opportunitySavingsColumnLabel;
    /**
     * @var string
     */
    public $passedAuditsGroupTitle;
    /**
     * @var string
     */
    public $runtimeDesktopEmulation;
    /**
     * @var string
     */
    public $runtimeMobileEmulation;
    /**
     * @var string
     */
    public $runtimeNoEmulation;
    /**
     * @var string
     */
    public $runtimeSettingsAxeVersion;
    /**
     * @var string
     */
    public $runtimeSettingsBenchmark;
    /**
     * @var string
     */
    public $runtimeSettingsCPUThrottling;
    /**
     * @var string
     */
    public $runtimeSettingsChannel;
    /**
     * @var string
     */
    public $runtimeSettingsDevice;
    /**
     * @var string
     */
    public $runtimeSettingsFetchTime;
    /**
     * @var string
     */
    public $runtimeSettingsNetworkThrottling;
    /**
     * @var string
     */
    public $runtimeSettingsTitle;
    /**
     * @var string
     */
    public $runtimeSettingsUA;
    /**
     * @var string
     */
    public $runtimeSettingsUANetwork;
    /**
     * @var string
     */
    public $runtimeSettingsUrl;
    /**
     * @var string
     */
    public $runtimeUnknown;
    /**
     * @var string
     */
    public $scorescaleLabel;
    /**
     * @var string
     */
    public $showRelevantAudits;
    /**
     * @var string
     */
    public $snippetCollapseButtonLabel;
    /**
     * @var string
     */
    public $snippetExpandButtonLabel;
    /**
     * @var string
     */
    public $thirdPartyResourcesLabel;
    /**
     * @var string
     */
    public $throttlingProvided;
    /**
     * @var string
     */
    public $toplevelWarningsMessage;
    /**
     * @var string
     */
    public $varianceDisclaimer;
    /**
     * @var string
     */
    public $viewTreemapLabel;
    /**
     * @var string
     */
    public $warningAuditsGroupTitle;
    /**
     * @var string
     */
    public $warningHeader;
    /**
     * @param string
     */
    public function setAuditGroupExpandTooltip($auditGroupExpandTooltip)
    {
        $this->auditGroupExpandTooltip = $auditGroupExpandTooltip;
    }
    /**
     * @return string
     */
    public function getAuditGroupExpandTooltip()
    {
        return $this->auditGroupExpandTooltip;
    }
    /**
     * @param string
     */
    public function setCalculatorLink($calculatorLink)
    {
        $this->calculatorLink = $calculatorLink;
    }
    /**
     * @return string
     */
    public function getCalculatorLink()
    {
        return $this->calculatorLink;
    }
    /**
     * @param string
     */
    public function setCrcInitialNavigation($crcInitialNavigation)
    {
        $this->crcInitialNavigation = $crcInitialNavigation;
    }
    /**
     * @return string
     */
    public function getCrcInitialNavigation()
    {
        return $this->crcInitialNavigation;
    }
    /**
     * @param string
     */
    public function setCrcLongestDurationLabel($crcLongestDurationLabel)
    {
        $this->crcLongestDurationLabel = $crcLongestDurationLabel;
    }
    /**
     * @return string
     */
    public function getCrcLongestDurationLabel()
    {
        return $this->crcLongestDurationLabel;
    }
    /**
     * @param string
     */
    public function setDropdownCopyJSON($dropdownCopyJSON)
    {
        $this->dropdownCopyJSON = $dropdownCopyJSON;
    }
    /**
     * @return string
     */
    public function getDropdownCopyJSON()
    {
        return $this->dropdownCopyJSON;
    }
    /**
     * @param string
     */
    public function setDropdownDarkTheme($dropdownDarkTheme)
    {
        $this->dropdownDarkTheme = $dropdownDarkTheme;
    }
    /**
     * @return string
     */
    public function getDropdownDarkTheme()
    {
        return $this->dropdownDarkTheme;
    }
    /**
     * @param string
     */
    public function setDropdownPrintExpanded($dropdownPrintExpanded)
    {
        $this->dropdownPrintExpanded = $dropdownPrintExpanded;
    }
    /**
     * @return string
     */
    public function getDropdownPrintExpanded()
    {
        return $this->dropdownPrintExpanded;
    }
    /**
     * @param string
     */
    public function setDropdownPrintSummary($dropdownPrintSummary)
    {
        $this->dropdownPrintSummary = $dropdownPrintSummary;
    }
    /**
     * @return string
     */
    public function getDropdownPrintSummary()
    {
        return $this->dropdownPrintSummary;
    }
    /**
     * @param string
     */
    public function setDropdownSaveGist($dropdownSaveGist)
    {
        $this->dropdownSaveGist = $dropdownSaveGist;
    }
    /**
     * @return string
     */
    public function getDropdownSaveGist()
    {
        return $this->dropdownSaveGist;
    }
    /**
     * @param string
     */
    public function setDropdownSaveHTML($dropdownSaveHTML)
    {
        $this->dropdownSaveHTML = $dropdownSaveHTML;
    }
    /**
     * @return string
     */
    public function getDropdownSaveHTML()
    {
        return $this->dropdownSaveHTML;
    }
    /**
     * @param string
     */
    public function setDropdownSaveJSON($dropdownSaveJSON)
    {
        $this->dropdownSaveJSON = $dropdownSaveJSON;
    }
    /**
     * @return string
     */
    public function getDropdownSaveJSON()
    {
        return $this->dropdownSaveJSON;
    }
    /**
     * @param string
     */
    public function setDropdownViewer($dropdownViewer)
    {
        $this->dropdownViewer = $dropdownViewer;
    }
    /**
     * @return string
     */
    public function getDropdownViewer()
    {
        return $this->dropdownViewer;
    }
    /**
     * @param string
     */
    public function setErrorLabel($errorLabel)
    {
        $this->errorLabel = $errorLabel;
    }
    /**
     * @return string
     */
    public function getErrorLabel()
    {
        return $this->errorLabel;
    }
    /**
     * @param string
     */
    public function setErrorMissingAuditInfo($errorMissingAuditInfo)
    {
        $this->errorMissingAuditInfo = $errorMissingAuditInfo;
    }
    /**
     * @return string
     */
    public function getErrorMissingAuditInfo()
    {
        return $this->errorMissingAuditInfo;
    }
    /**
     * @param string
     */
    public function setFooterIssue($footerIssue)
    {
        $this->footerIssue = $footerIssue;
    }
    /**
     * @return string
     */
    public function getFooterIssue()
    {
        return $this->footerIssue;
    }
    /**
     * @param string
     */
    public function setLabDataTitle($labDataTitle)
    {
        $this->labDataTitle = $labDataTitle;
    }
    /**
     * @return string
     */
    public function getLabDataTitle()
    {
        return $this->labDataTitle;
    }
    /**
     * @param string
     */
    public function setLsPerformanceCategoryDescription($lsPerformanceCategoryDescription)
    {
        $this->lsPerformanceCategoryDescription = $lsPerformanceCategoryDescription;
    }
    /**
     * @return string
     */
    public function getLsPerformanceCategoryDescription()
    {
        return $this->lsPerformanceCategoryDescription;
    }
    /**
     * @param string
     */
    public function setManualAuditsGroupTitle($manualAuditsGroupTitle)
    {
        $this->manualAuditsGroupTitle = $manualAuditsGroupTitle;
    }
    /**
     * @return string
     */
    public function getManualAuditsGroupTitle()
    {
        return $this->manualAuditsGroupTitle;
    }
    /**
     * @param string
     */
    public function setNotApplicableAuditsGroupTitle($notApplicableAuditsGroupTitle)
    {
        $this->notApplicableAuditsGroupTitle = $notApplicableAuditsGroupTitle;
    }
    /**
     * @return string
     */
    public function getNotApplicableAuditsGroupTitle()
    {
        return $this->notApplicableAuditsGroupTitle;
    }
    /**
     * @param string
     */
    public function setOpportunityResourceColumnLabel($opportunityResourceColumnLabel)
    {
        $this->opportunityResourceColumnLabel = $opportunityResourceColumnLabel;
    }
    /**
     * @return string
     */
    public function getOpportunityResourceColumnLabel()
    {
        return $this->opportunityResourceColumnLabel;
    }
    /**
     * @param string
     */
    public function setOpportunitySavingsColumnLabel($opportunitySavingsColumnLabel)
    {
        $this->opportunitySavingsColumnLabel = $opportunitySavingsColumnLabel;
    }
    /**
     * @return string
     */
    public function getOpportunitySavingsColumnLabel()
    {
        return $this->opportunitySavingsColumnLabel;
    }
    /**
     * @param string
     */
    public function setPassedAuditsGroupTitle($passedAuditsGroupTitle)
    {
        $this->passedAuditsGroupTitle = $passedAuditsGroupTitle;
    }
    /**
     * @return string
     */
    public function getPassedAuditsGroupTitle()
    {
        return $this->passedAuditsGroupTitle;
    }
    /**
     * @param string
     */
    public function setRuntimeDesktopEmulation($runtimeDesktopEmulation)
    {
        $this->runtimeDesktopEmulation = $runtimeDesktopEmulation;
    }
    /**
     * @return string
     */
    public function getRuntimeDesktopEmulation()
    {
        return $this->runtimeDesktopEmulation;
    }
    /**
     * @param string
     */
    public function setRuntimeMobileEmulation($runtimeMobileEmulation)
    {
        $this->runtimeMobileEmulation = $runtimeMobileEmulation;
    }
    /**
     * @return string
     */
    public function getRuntimeMobileEmulation()
    {
        return $this->runtimeMobileEmulation;
    }
    /**
     * @param string
     */
    public function setRuntimeNoEmulation($runtimeNoEmulation)
    {
        $this->runtimeNoEmulation = $runtimeNoEmulation;
    }
    /**
     * @return string
     */
    public function getRuntimeNoEmulation()
    {
        return $this->runtimeNoEmulation;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsAxeVersion($runtimeSettingsAxeVersion)
    {
        $this->runtimeSettingsAxeVersion = $runtimeSettingsAxeVersion;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsAxeVersion()
    {
        return $this->runtimeSettingsAxeVersion;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsBenchmark($runtimeSettingsBenchmark)
    {
        $this->runtimeSettingsBenchmark = $runtimeSettingsBenchmark;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsBenchmark()
    {
        return $this->runtimeSettingsBenchmark;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsCPUThrottling($runtimeSettingsCPUThrottling)
    {
        $this->runtimeSettingsCPUThrottling = $runtimeSettingsCPUThrottling;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsCPUThrottling()
    {
        return $this->runtimeSettingsCPUThrottling;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsChannel($runtimeSettingsChannel)
    {
        $this->runtimeSettingsChannel = $runtimeSettingsChannel;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsChannel()
    {
        return $this->runtimeSettingsChannel;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsDevice($runtimeSettingsDevice)
    {
        $this->runtimeSettingsDevice = $runtimeSettingsDevice;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsDevice()
    {
        return $this->runtimeSettingsDevice;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsFetchTime($runtimeSettingsFetchTime)
    {
        $this->runtimeSettingsFetchTime = $runtimeSettingsFetchTime;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsFetchTime()
    {
        return $this->runtimeSettingsFetchTime;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsNetworkThrottling($runtimeSettingsNetworkThrottling)
    {
        $this->runtimeSettingsNetworkThrottling = $runtimeSettingsNetworkThrottling;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsNetworkThrottling()
    {
        return $this->runtimeSettingsNetworkThrottling;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsTitle($runtimeSettingsTitle)
    {
        $this->runtimeSettingsTitle = $runtimeSettingsTitle;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsTitle()
    {
        return $this->runtimeSettingsTitle;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsUA($runtimeSettingsUA)
    {
        $this->runtimeSettingsUA = $runtimeSettingsUA;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsUA()
    {
        return $this->runtimeSettingsUA;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsUANetwork($runtimeSettingsUANetwork)
    {
        $this->runtimeSettingsUANetwork = $runtimeSettingsUANetwork;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsUANetwork()
    {
        return $this->runtimeSettingsUANetwork;
    }
    /**
     * @param string
     */
    public function setRuntimeSettingsUrl($runtimeSettingsUrl)
    {
        $this->runtimeSettingsUrl = $runtimeSettingsUrl;
    }
    /**
     * @return string
     */
    public function getRuntimeSettingsUrl()
    {
        return $this->runtimeSettingsUrl;
    }
    /**
     * @param string
     */
    public function setRuntimeUnknown($runtimeUnknown)
    {
        $this->runtimeUnknown = $runtimeUnknown;
    }
    /**
     * @return string
     */
    public function getRuntimeUnknown()
    {
        return $this->runtimeUnknown;
    }
    /**
     * @param string
     */
    public function setScorescaleLabel($scorescaleLabel)
    {
        $this->scorescaleLabel = $scorescaleLabel;
    }
    /**
     * @return string
     */
    public function getScorescaleLabel()
    {
        return $this->scorescaleLabel;
    }
    /**
     * @param string
     */
    public function setShowRelevantAudits($showRelevantAudits)
    {
        $this->showRelevantAudits = $showRelevantAudits;
    }
    /**
     * @return string
     */
    public function getShowRelevantAudits()
    {
        return $this->showRelevantAudits;
    }
    /**
     * @param string
     */
    public function setSnippetCollapseButtonLabel($snippetCollapseButtonLabel)
    {
        $this->snippetCollapseButtonLabel = $snippetCollapseButtonLabel;
    }
    /**
     * @return string
     */
    public function getSnippetCollapseButtonLabel()
    {
        return $this->snippetCollapseButtonLabel;
    }
    /**
     * @param string
     */
    public function setSnippetExpandButtonLabel($snippetExpandButtonLabel)
    {
        $this->snippetExpandButtonLabel = $snippetExpandButtonLabel;
    }
    /**
     * @return string
     */
    public function getSnippetExpandButtonLabel()
    {
        return $this->snippetExpandButtonLabel;
    }
    /**
     * @param string
     */
    public function setThirdPartyResourcesLabel($thirdPartyResourcesLabel)
    {
        $this->thirdPartyResourcesLabel = $thirdPartyResourcesLabel;
    }
    /**
     * @return string
     */
    public function getThirdPartyResourcesLabel()
    {
        return $this->thirdPartyResourcesLabel;
    }
    /**
     * @param string
     */
    public function setThrottlingProvided($throttlingProvided)
    {
        $this->throttlingProvided = $throttlingProvided;
    }
    /**
     * @return string
     */
    public function getThrottlingProvided()
    {
        return $this->throttlingProvided;
    }
    /**
     * @param string
     */
    public function setToplevelWarningsMessage($toplevelWarningsMessage)
    {
        $this->toplevelWarningsMessage = $toplevelWarningsMessage;
    }
    /**
     * @return string
     */
    public function getToplevelWarningsMessage()
    {
        return $this->toplevelWarningsMessage;
    }
    /**
     * @param string
     */
    public function setVarianceDisclaimer($varianceDisclaimer)
    {
        $this->varianceDisclaimer = $varianceDisclaimer;
    }
    /**
     * @return string
     */
    public function getVarianceDisclaimer()
    {
        return $this->varianceDisclaimer;
    }
    /**
     * @param string
     */
    public function setViewTreemapLabel($viewTreemapLabel)
    {
        $this->viewTreemapLabel = $viewTreemapLabel;
    }
    /**
     * @return string
     */
    public function getViewTreemapLabel()
    {
        return $this->viewTreemapLabel;
    }
    /**
     * @param string
     */
    public function setWarningAuditsGroupTitle($warningAuditsGroupTitle)
    {
        $this->warningAuditsGroupTitle = $warningAuditsGroupTitle;
    }
    /**
     * @return string
     */
    public function getWarningAuditsGroupTitle()
    {
        return $this->warningAuditsGroupTitle;
    }
    /**
     * @param string
     */
    public function setWarningHeader($warningHeader)
    {
        $this->warningHeader = $warningHeader;
    }
    /**
     * @return string
     */
    public function getWarningHeader()
    {
        return $this->warningHeader;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\PagespeedInsights\RendererFormattedStrings::class, 'Google\\Site_Kit_Dependencies\\Google_Service_PagespeedInsights_RendererFormattedStrings');
