<?php

final class ITSEC_Malware_Scheduling_Settings_Page extends ITSEC_Module_Settings_Page {
	public function __construct() {
		$this->id            = 'malware-scheduling';
		$this->title         = __( 'Site Scan Scheduling', 'it-l10n-ithemes-security-pro' );
		$this->description   = __( 'Protect your site with automated site scans. When this feature is enabled, the site will be automatically scanned each day. If a problem is found, an email is sent to select users.', 'it-l10n-ithemes-security-pro' );
		$this->type          = 'recommended';
		$this->pro           = true;
		$this->documentation = 'https://help.ithemes.com/hc/en-us/articles/360046334433';

		parent::__construct();
	}

	protected function render_description( $form ) {
		$description = __( 'This site scan is powered by iThemes. We use several datapoints to check for known malware, blocklist status, website errors and out-of-date software. These datapoints are not 100% accurate, but we try our best to provide thorough results.', 'it-l10n-ithemes-security-pro' );
		?>
		<p><?php echo $description; ?></p>
		<p><?php printf( __( 'Results of previous scans can be found on the <a href="%s">logs page</a>.', 'it-l10n-ithemes-security-pro' ), ITSEC_Core::get_logs_page_url( array( 'module' => 'site-scanner' ) ) ); ?></p>
		<?php
	}

	protected function render_settings( $form ) {

	}
}

new ITSEC_Malware_Scheduling_Settings_Page();
