<?php

$path = 'inc/minify-master';
$path_converter = 'inc/path-converter';
include_once $path . '/src/Minify.php';
include_once $path . '/src/CSS.php';
include_once $path . '/src/JS.php';
include_once $path . '/src/Exception.php';
include_once $path . '/src/Exceptions/BasicException.php';
include_once $path . '/src/Exceptions/FileImportException.php';
include_once $path . '/src/Exceptions/IOException.php';
include_once $path_converter . '/src/ConverterInterface.php';
include_once $path_converter . '/src/Converter.php';
use MatthiasMullie\Minify;

if(!function_exists('lp_register_minifer_menu_page')){
	function lp_register_minifer_menu_page(){
		
		add_menu_page( 
			__( 'Listingpro Minifier', 'listingpro-minifier' ),
			'Listingpro Minifier',
			'manage_options',
			'lp-minify',
			'lp_minify_page_content',
			'dashicons-chart-bar',
			35
		); 
	}
}
add_action( 'admin_menu', 'lp_register_minifer_menu_page' );


/**
 * Display a custom menu page
 */
if(!function_exists('lp_minify_page_content')){
	function lp_minify_page_content(){
		
		/* get existing values */
		
		$themecssStatus = lp_check_minify_status('themecss');
		$themejsStatus = lp_check_minify_status('themejs');
		$plugincssStatus = lp_check_minify_status('plugincss');
		$pluginjsStatus = lp_check_minify_status('pluginjs');
		
		$themecssClass = 'inactive';
		$themejsClass = 'inactive';
		$plugincssClass = 'inactive';
		$pluginjsClass = 'inactive';
		
		$themecssLabel = esc_html__('INACTIVE', 'listingpro-minifier');
		$themejsLabel = esc_html__('INACTIVE', 'listingpro-minifier');
		$plugincssLabel = esc_html__('INACTIVE', 'listingpro-minifier');
		$pluginjsLabel = esc_html__('INACTIVE', 'listingpro-minifier');
		
		if(!empty($themecssStatus)){
			$themecssClass = 'btn-success';
			$themecssLabel = esc_html__('MINIFIED', 'listingpro-minifier');
		}
		if(!empty($themejsStatus)){
			$themejsClass = 'btn-success';
			$themejsLabel = esc_html__('MINIFIED', 'listingpro-minifier');
		}
		if(!empty($plugincssStatus)){
			$plugincssClass = 'btn-success';
			$plugincssLabel = esc_html__('MINIFIED', 'listingpro-minifier');
		}
		if(!empty($pluginjsStatus)){
			$pluginjsClass = 'btn-success';
			$pluginjsLabel = esc_html__('MINIFIED', 'listingpro-minifier');
		}
		
		
		?>
		
		<div class="wrap listingpro-coupons">
			<h1 class="wp-heading-inline"><?php echo esc_html__('Minifyr', 'listingpro-minifier'); ?></h1>
			<div class="clearfix"></div>
			<div class="col-sm-12">


				<p><?php echo esc_html__('Minifyr helps Minify ListingPro Theme and Plugin’s CSS and JS files. Minification refers to the process of removing unnecessary or redundant data without affecting how the resource is processed by the browser - e.g. code comments and formatting, removing unused code, using shorter variable and function names, and so on.', 'listingpro-minifier'); ?></p>
			</div>
			<div class="col-sm-12">
				<div class="listing-minifyr">
					<?php
						$lpMakePassive = '';
						$lpMakePassiveChcked = false;
						$hidethistableminify = 'hidethistableminify';
						$consentactive = get_option('lp_minify_consent');
						if(!empty($consentactive)){
							$lpMakePassive = 'disabled';
							$hidethistableminify = '';
							$lpMakePassiveChcked = 'checked';
						}
					?>
					<div class="checkbox">
						<label>
							<input type="checkbox" value="" <?php echo $lpMakePassive.' '.$lpMakePassiveChcked; ?>> <strong class="maginy-notice"><?php echo esc_html__('You must check this box to confirm that you are NOT testing this feature in production environtment and you take full responsiblity if your site breaks. You must also take the following in consideration:', 'listingpro-minifier'); ?></strong>
							<ul class="minifyr-main-points">
								<li><strong><?php echo esc_html__('Disable minify option in other Cashe plugins (E.g. WP Super Cache)', 'listingpro-minifier'); ?></strong></li>
								<li><strong><?php echo esc_html__('Before activate the Minify feature you must clear your cache from a builtin cache plugin and the server side if any.', 'listingpro-minifier'); ?></strong></li>
							</ul>
							
							
						</label>
						
					</div>

				</div>

			</div>


			<div class="col-sm-12">
				<div class="listing-minify-css-table <?php echo $hidethistableminify; ?>">

					<table class="table">
						<thead>
							<tr>
								<th class="manage-column column-title">Minify Css</th>
								<th class="manage-column column-categories">Off / On</th>
								<th class="manage-column column-categories">Status</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td class="row-title"><h4><?php echo esc_html__('Theme', 'listingpro-minifier'); ?></h4>
									<span><?php echo esc_html__('Click to Minfify css listingpro theme', 'listingpro-minifier'); ?></span>
								</td>
								<td class="manage-column column-categories">
									<label class="switch">
										<input class="lp_themeplugin_minify_switch" data-type="themecss" type="checkbox" <?php echo $themecssStatus; ?>>
										<span class="slider round"></span>
									</label>

								</td>
								<td class="manage-column column-categories"><button type="button" class="btn <?php echo $themecssClass; ?>"><?php echo $themecssLabel; ?></button><i class='lpthisloading fa fa-spinner fa-spin'></i></td>
								
							</tr>
							<tr>
								<td class="row-title"><h4><?php echo esc_html__('Plugin', 'listingpro-minifier'); ?></h4>
									<span><?php echo esc_html__('Click to Minfify css listingpro plugin', 'listingpro-minifier'); ?></span>
								</td>
								<td class="manage-column column-categories"><label class="switch">
										<input class="lp_themeplugin_minify_switch" data-type="plugincss"  type="checkbox" <?php echo $plugincssStatus; ?>>
										<span class="slider round"></span>
									</label></td>
								<td class="manage-column column-categories"><button type="button" class="btn <?php echo $plugincssClass; ?>"><?php echo $plugincssLabel; ?></button><i class='lpthisloading fa fa-spinner fa-spin'></i></td>
							</tr>
							
						</tbody>
					</table>
				</div>
			</div>




			<div class="col-sm-12">
				<div class="listing-minify-css-table <?php echo $hidethistableminify; ?>">

					<table class="table">
						<thead>
							<tr>
								<th>Minify Js</th>
								<th class="manage-column column-categories"> Off / On</th>
								<th class="manage-column column-categories"> Status</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td class="row-title"><h4><?php echo esc_html__('Theme', 'listingpro-minifier'); ?></h4>
									<span><?php echo esc_html__('Click to Minfify js listingpro theme', 'listingpro-minifier'); ?></span>
								</td>
								<td class="manage-column column-categories"><label class="switch">
										<input class="lp_themeplugin_minify_switch" data-type="themejs"  type="checkbox" <?php echo $themejsStatus; ?>>
										<span class="slider round"></span>
									</label></td>
								<td class="manage-column column-categories"><button type="button" class="btn <?php echo $themejsClass; ?>"><?php echo $themejsLabel; ?></button><i class='lpthisloading fa fa-spinner fa-spin'></i></td>
							</tr>
							<tr>
								<td class="row-title"><h4><?php echo esc_html__('Plugin', 'listingpro-minifier'); ?></h4>
									<span><?php echo esc_html__('Click to Minfify js listingpro plugin', 'listingpro-minifier'); ?></span>
								</td>
								<td class="manage-column column-categories"><label class="switch">
										<input class="lp_themeplugin_minify_switch" data-type="pluginjs"  type="checkbox" <?php echo $pluginjsStatus; ?>>
										<span class="slider round"></span>
									</label></td>
								<td class="manage-column column-categories"><button type="button" class="btn <?php echo $pluginjsClass; ?>"><?php echo $pluginjsLabel; ?></button><i class='lpthisloading fa fa-spinner fa-spin'></i></td>
							</tr>
							
						</tbody>
					</table>
				</div>
			</div>



			<?php

		}

	}
	
	
	
	
	/* including js and css */
	if( !function_exists('lp_load_minifer_js') ){
		function lp_load_minifer_js($hook) {
				wp_enqueue_style( 'lploadminfiercss', plugin_dir_url( __FILE__ ) . 'css/minify-js.css');
				 wp_enqueue_script( 'lploadminfierjs', plugin_dir_url( __FILE__ ) . 'js/minify-js.js', array(), '1.0.0', true );
				 
		}
	}
	add_action( 'admin_enqueue_scripts', 'lp_load_minifer_js' );
	
	
	/* ajax for minify */
	add_action('wp_ajax_lp_process_lp_minify_action', 'lp_process_lp_minify_action');
	add_action('wp_ajax_nopriv_lp_process_lp_minify_action', 'lp_process_lp_minify_action');
	if(!function_exists('lp_process_lp_minify_action')){
		function lp_process_lp_minify_action($typee = null, $statuss=null){
			$response = array();
			if(isset($_POST['type'])){
				$type = $_POST['type'];
			}
			if(isset($_POST['status'])){
				$status = $_POST['status'];
			}
			if(!empty($type) && !empty($status)){
				/* for ajax */
				$response['response'] = lp_add_minify_results($type, $status);
				exit(json_encode($response));
			}elseif( empty($type) && empty($status) ){
				/* for deactive plugin */
				if(!empty($typee) && !empty($statuss)){
					$response['response'] = lp_add_minify_results($typee, $statuss);
				}
			}
			
		}
	}
	
	/* function to check status of minify */
	if(!function_exists('lp_check_minify_status')){
		function lp_check_minify_status($type){
			$lp_minify_status = get_option('lp_minify_status');
				if(!empty($lp_minify_status)){
					if(isset($lp_minify_status[$type])){
						if(!empty($lp_minify_status[$type])){
							return 'checked';
						}
					}
				}
				return;
				
		}
	}
	
	/* function to check status of minify */
	if(!function_exists('lp_add_minify_results')){
		function lp_add_minify_results($type, $status){
			$thisType = $type;
			$lp_minify_status = get_option('lp_minify_status');
			$source = '';
			if($thisType == "themecss" || $thisType == "themejs"){
				$source = 'theme';
			}elseif($thisType == "plugincss" || $thisType == "pluginjs"){
				$source = 'plugin';
			}
			
			if(!empty($lp_minify_status)){
				if($status=="active"){
					$lp_minify_status[$type] = '1';
				}else{
					$lp_minify_status[$type] = '0';
				}
			}
			else{
				if($status=="active"){
					$lp_minify_status[$type] = '1';
				}else{
					$lp_minify_status[$type] = '0';
				}
			}
			lp_do_minifyprocess($type, $source, $status);
			$dataRet['resp'] = update_option('lp_minify_status', $lp_minify_status);
			$dataRet['status'] = $status;
			return $dataRet;
		}
	}
	
	/* processing minify */
	
	/**
		* Process minify 
		*/
		
		if(!function_exists('lp_do_minifyprocess')){
			function lp_do_minifyprocess($type, $source, $status){
				define('lp_theme_url', get_stylesheet_directory_uri());
				define('lp_theme_path', get_stylesheet_directory(__FILE__));
				define('lp_plugins_url', plugins_url());
				define('lp_plugins_path', plugin_dir_path(__DIR__ ));
				
				$lpThemeDirJs = lp_theme_path.'/assets/js';
				$lpTHemeJs = array_diff((scandir($lpThemeDirJs, 1)), array('..', '.'));
				
				
				$lpThemeDirCss    = lp_theme_path . '/assets/css';
				$lpTHemeCss = array_diff((scandir($lpThemeDirCss, 1)), array('..', '.'));
				
				
				$lpPluginDirJs = lp_plugins_path.'listingpro-plugin/assets/js';
				$lpPluginJs = array_diff((scandir($lpPluginDirJs, 1)), array('..', '.'));
				
				$lpPluginDirCss    = lp_plugins_path . 'listingpro-plugin/assets/css';
				$lpPluginCss = array_diff((scandir($lpPluginDirCss, 1)), array('..', '.'));
				if( $type=="themecss" && $source=="theme" ){
					/* for theme */
					
					/**
					css */
					
					$lpcssArray = array();
					if(!empty($lpTHemeCss)){
						foreach($lpTHemeCss as $singleCss){
							
							$objbulkMinifier = new ListingMinifier();
							$lpFileType = $objbulkMinifier->lp_get_file_extension($singleCss);
							if($lpFileType=='css'){
								$filePath = $lpThemeDirCss.'/'.$singleCss;
								if($status == 'deactive'){
									if (strpos($singleCss, "lptemp-") ==0){
										$ofileName = lp_get_substring_after_substring_in_string($singleCss, 'lptemp-');
										if(!empty($ofileName)){
											$ofilePath = $lpThemeDirCss.'/'.$ofileName;
											$temptfilePath = $filePath;
											$str = file_get_contents("$temptfilePath");
											file_put_contents("$ofilePath", $str);
											unlink($temptfilePath);
										}
										
									}
								}else{
									copy( lp_theme_path.'/assets/css/'.$singleCss, lp_theme_path.'/assets/css/lptemp-'.$singleCss );
									$minifier = new Minify\CSS($filePath);
									$minifier->minify($filePath);
								}
								
							}
						}
						
					}
					
					
				}elseif( $type=="themejs" && $source=="theme" ){
					/**
					js */
					$lpjsArray = array();
					if(!empty($lpTHemeJs)){
						foreach($lpTHemeJs as $singleJs){
							
							$objbulkMinifier = new ListingMinifier();
							$lpFileType = $objbulkMinifier->lp_get_file_extension($singleJs);
							if($lpFileType=='js'){
								$filePath = $lpThemeDirJs.'/'.$singleJs;
								if($status == 'deactive'){
									
									if (strpos($singleJs, "lptemp-") ==0){
										$ofileName = lp_get_substring_after_substring_in_string($singleJs, 'lptemp-');
										if(!empty($ofileName)){
											$ofilePath = $lpThemeDirJs.'/'.$ofileName;
											$temptfilePath = $filePath;
											$str = file_get_contents("$temptfilePath");
											file_put_contents("$ofilePath", $str);
											unlink($temptfilePath);
										}
										
									}
									
								}else{
									copy( lp_theme_path.'/assets/js/'.$singleJs, lp_theme_path.'/assets/js/lptemp-'.$singleJs );
									$minifier = new Minify\JS($filePath);
									$minifier->minify($filePath);
								}
							}
						}
						
						
					}
					
					
					
				}elseif( $type=="plugincss" && $source=="plugin" ){
					/* for plugin */
					
					/**
					css */
					
					$lpcssArray = array();
					if(!empty($lpPluginCss)){
						foreach($lpPluginCss as $singleCss){
							
							$objbulkMinifier = new ListingMinifier();
							$lpFileType = $objbulkMinifier->lp_get_file_extension($singleCss);
							if($lpFileType=='css'){
								
								
								$filePath = $lpPluginDirCss.'/'.$singleCss;
								if($status == 'deactive'){
									if (strpos($singleCss, "lptemp-") ==0){
										$ofileName = lp_get_substring_after_substring_in_string($singleCss, 'lptemp-');
										if(!empty($ofileName)){
											$ofilePath = $lpPluginDirCss.'/'.$ofileName;
											$temptfilePath = $filePath;
											$str = file_get_contents("$temptfilePath");
											file_put_contents("$ofilePath", $str);
											unlink($temptfilePath);
										}
										
									}
									
									
								}else{
									copy( lp_plugins_path.'listingpro-plugin/assets/css/'.$singleCss, lp_plugins_path.'listingpro-plugin/assets/css/lptemp-'.$singleCss );
									$minifier = new Minify\CSS($filePath);
									$minifier->minify($filePath);
								}
							}
						}
						
						
					}
					
				}elseif( $type=="pluginjs" && $source=="plugin" ){
					
					/**
					js */
					$lpjsArray = array();
					if(!empty($lpPluginJs)){
						foreach($lpPluginJs as $singleJs){
							
							$objbulkMinifier = new ListingMinifier();
							$lpFileType = $objbulkMinifier->lp_get_file_extension($singleJs);
							if($lpFileType=='js'){
								$filePath = $lpPluginDirJs.'/'.$singleJs;
								if($status == 'deactive'){
									if (strpos($singleJs, "lptemp-") ==0){
										$ofileName = lp_get_substring_after_substring_in_string($singleJs, 'lptemp-');
										if(!empty($ofileName)){
											$ofilePath = $lpPluginDirJs.'/'.$ofileName;
											$temptfilePath = $filePath;
											$str = file_get_contents("$temptfilePath");
											file_put_contents("$ofilePath", $str);
											unlink($temptfilePath);
										}
										
									}
								}else{
									copy( lp_plugins_path.'listingpro-plugin/assets/js/'.$singleJs, lp_plugins_path.'listingpro-plugin/assets/js/lptemp-'.$singleJs );
									$minifier = new Minify\JS($filePath);
									$minifier->minify($filePath);
									
								}
							}
						}
						
						
						
					}
				
				}
				
			}
			
			
		}
		/*get substring after matching within a string*/
		if(!function_exists('lp_get_substring_after_substring_in_string')){
			function lp_get_substring_after_substring_in_string($string, $substring){
				$pos = strpos($string, $substring);
				if ($pos === false)
					return false;
				else  
					return(substr($string, $pos+strlen($substring)));
			}
		}
		
		/* consent ajax*/
		
		add_action('wp_ajax_lp_consent_minify_action', 'lp_consent_minify_action');
		add_action('wp_ajax_nopriv_lp_consent_minify_action', 'lp_consent_minify_action');
		if(!function_exists('lp_consent_minify_action')){
			function lp_consent_minify_action(){
				$response = array();
				$response = update_option('lp_minify_consent', 'active');
				exit(json_encode($response));
				
			}
		}